package zigen.plugin.db.ext.jdt.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.dialogs.PropertyPage;

import zigen.plugin.db.core.DBConfigManager;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.ext.jdt.Activator;

public class DBPropertyPage extends PropertyPage {

	private static final String CONNECT_DB = Messages.getString("DBPropertyPage.0"); //$NON-NLS-1$

	public static final String QUALIFIER = "zigen.plugin.db"; //$NON-NLS-1$

	public static final String SELECTED_DB = "SELECTED_DB"; //$NON-NLS-1$

	public static final String INITIAL_VALUE = Messages.getString("DBPropertyPage.3"); //$NON-NLS-1$

	private Combo selectCombo;

	private IDBConfig[] configs;

	private IProject project;

	public DBPropertyPage() {
		super();
	}

	protected Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		composite.setLayout(layout);
		GridData data = new GridData(GridData.FILL);
		data.grabExcessHorizontalSpace = true;
		composite.setLayoutData(data);

		createSelectCombo(composite);
		// addSeparator(composite);
		return composite;
	}

	private Composite createDefaultComposite(Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		composite.setLayout(layout);
		GridData data = new GridData();
		data.verticalAlignment = GridData.FILL;
		data.horizontalAlignment = GridData.FILL;
		composite.setLayoutData(data);
		return composite;
	}

	private void createSelectCombo(Composite parent) {

		Composite composite = createDefaultComposite(parent);
		Label pathLabel = new Label(composite, SWT.NONE);
		pathLabel.setText(CONNECT_DB);

		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		data.widthHint = 200;

		selectCombo = new Combo(composite, SWT.READ_ONLY);
		selectCombo.setLayoutData(data);
		selectCombo.add(INITIAL_VALUE);

		configs = DBConfigManager.getDBConfigs();

		Object obj = getElement();

        if (obj instanceof IJavaProject) {
            project = ((IJavaProject) obj).getProject();
            setDefaultValue(project);
        } else if (obj instanceof IProject) {
            project = (IProject) obj;
            setDefaultValue(project);
        }
	}

	private void setDefaultValue(IProject project) {
		try {
			String dbName = project.getPersistentProperty(new QualifiedName(QUALIFIER, SELECTED_DB));

			for (int i = 0; i < configs.length; i++) {
				IDBConfig w_config = configs[i];
				selectCombo.add(w_config.getDbName());
				if (i == 0)
					selectCombo.select(0);
				if (dbName != null && dbName.equals(w_config.getDbName())) {
					selectCombo.select(i + 1);

				}
			}
		} catch (Exception e) {
			Activator.log(e);
		}

	}

	protected void performDefaults() {

	}

	public boolean performOk() {
		try {

			if (project != null) {
				int i = selectCombo.getSelectionIndex();
				if (i >= 0) {
					String dbName = selectCombo.getItem(i);
					project.setPersistentProperty(new QualifiedName(QUALIFIER, SELECTED_DB), dbName);
				}
			}
		} catch (Exception e) {
            Activator.log(e);
			return false;
		}
		return true;
	}

}
